package com.example.demo;

import jakarta.annotation.PostConstruct;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.client.RestClient;

import java.util.List;
import java.util.Map;

import static org.junit.jupiter.api.Assertions.assertTrue;

@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
class DemoApplicationTests {

    @Autowired
    private WebTestClient webClient;

    @Autowired
    private RestClient.Builder restClientBuilder;

    private RestClient restClient;

    @LocalServerPort
    private int port;

    @PostConstruct
    private void buildRestClient() {
        restClient = restClientBuilder.baseUrl("http://localhost:" + port)
            .defaultHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_VALUE)
            .build();
    }

    @Test
    void testEndpointWithWebClient() {

        var labels = webClient.get()
            .uri("/api/labels")
            .exchange()
            .expectStatus()
            .is2xxSuccessful()
            .returnResult(new ParameterizedTypeReference<ResponseWrapper<List<Label>>>() {
            })
            .getResponseBody()
            .blockFirst()
            .data();

        assertTrue(labels.getFirst() instanceof Label);
    }

    @Test
    void testEndpointWithRestClient() {

        var labels = restClient.get()
            .uri("/api/labels")
            .retrieve()
            .toEntity(new ParameterizedTypeReference<ResponseWrapper<List<Label>>>() {
            })
            .getBody()
            .data();

        assertTrue(labels.getFirst() instanceof Map);
        assertTrue(labels.getFirst() instanceof Label);
    }
}
