static const char webpagesseclient[] PROGMEM = R"R(
<!DOCTYPE html>
<script>
let evtSource;

function start() {
  let oReq = new XMLHttpRequest(); // subscribe and receive a channel
  oReq.open('GET', 'rest/events/subscribe');
  oReq.send();

  oReq.onload = function(e) {
  if (oReq.status != 200) {
    log('Error has occured.');
    log(`Error ${oReq.status}: ${oReq.statusText}`);
  } else {
    try {
      evtSource.close();
    }
    catch(error) {}

    evtSource = new EventSource(oReq.response);

    evtSource.onopen = function(event) {
      log('Event: open');
    };

    evtSource.onerror = function(err) {
      log('Event: EventSource failed:' + err);
      if (this.readyState == EventSource.CONNECTING) {
        log(`Reconnecting (readyState=${this.readyState})...`);
      } else {
        log('Error has occured.');
      }
    };

    evtSource.addEventListener('event', function(event) {
      log('Event: event, data: ' + event.data);
    });

  }
};

}

function stop() {
  evtSource.close();
  log('evtSource.close()');
}

function log(msg) {
  logger.innerHTML += msg + '<br>';
  document.documentElement.scrollTop = 99999999;
}
</script>

<button onclick="start()">Start</button>
<div id="logger"></div>

<button onclick="stop()">Stop</button>
)R";
