﻿using Nest;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;

namespace NEST2Test
{
    class Program
    {
        static void Main(string[] args)
        {
            var bulkResponses = new List<Task>();
            var randomGenerator = new Random();
            var indexName = "index" + randomGenerator.Next();
            //var connectionSettings = new ConnectionSettings(new Uri("http://localhost.:9200"));
            //connectionSettings.EnableTrace(true);
            //connectionSettings.ExposeRawResponse(true);

            var elastic = new ElasticClient();

            //Creates the index
            IIndicesOperationResponse createIndexResponse = elastic.CreateIndex(indexName, ci => ci
            .NumberOfReplicas(0)
            .AddMapping<BiTextDocumentIndex>(m => m.MapFromAttributes()));

            var biTextDocumentIndex = new BiTextDocumentIndex() { ID = Guid.NewGuid() };

            var bulkRequest = new BulkRequest
            {
                Refresh = false,
                Consistency = Elasticsearch.Net.Consistency.All,
                Index = indexName,
                Operations = new List<IBulkOperation>()
            };

            Stopwatch watch = new Stopwatch();
            watch.Start();

            for (int i = 0; i < 2000000; i++)
            {
                bulkRequest.Operations.Add(new BulkIndexOperation<BiTextDocumentIndex>(biTextDocumentIndex));
                biTextDocumentIndex = new BiTextDocumentIndex() { ID = Guid.NewGuid() };

                if (bulkRequest.Operations.Count == 50000)
                {
                    bulkResponses.Add(elastic.BulkAsync(bulkRequest));

                    bulkRequest = new BulkRequest
                    {
                        Refresh = true,
                        Consistency = Elasticsearch.Net.Consistency.All,
                        Index = indexName,
                        Operations = new List<IBulkOperation>()
                    };
                }
            }

            if (bulkRequest.Operations.Count > 0)
            {
                bulkResponses.Add(elastic.BulkAsync(bulkRequest));
            }

            Task.WaitAll(bulkResponses.ToArray());

            watch.Stop();
            Console.WriteLine("Total Time: " + watch.Elapsed);

        }
    }
}
