﻿using Nest;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading.Tasks;

namespace NEST2Test
{
    class Program
    {
        static void Main(string[] args)
        {
            var bulkResponses = new List<Task>();
            var connectionString = "http://localhost:9200";

            var local = new Uri(connectionString);
            var settings = new ConnectionSettings(local);
            var elastic = new ElasticClient(settings);
            var randomGenerator = new Random();
            var indexName = "index" + randomGenerator.Next();
            var createIndexResponse = elastic.CreateIndex(indexName, ci => ci
                        .Settings(s => s.NumberOfReplicas(0))
                        .Mappings(m => m.Map<BiTextDocumentIndex>(am => am.AutoMap()))
                        );

            var biTextDocumentIndex = new BiTextDocumentIndex() { ID = Guid.NewGuid() };

            var bulkRequest = new BulkRequest(indexName)
            {
                Refresh = false,
                Consistency = Elasticsearch.Net.Consistency.All,
                Operations = new List<IBulkOperation>()
            };

            Stopwatch watch = new Stopwatch();
            watch.Start();

            for (int i = 0; i < 2000000; i++)
            {
                bulkRequest.Operations.Add(new BulkIndexOperation<BiTextDocumentIndex>(biTextDocumentIndex));

                if (bulkRequest.Operations.Count == 50000)
                {
                    bulkResponses.Add(elastic.BulkAsync(bulkRequest));

                    bulkRequest = new BulkRequest(indexName)
                    {
                        Refresh = true,
                        Consistency = Elasticsearch.Net.Consistency.All,
                        Operations = new List<IBulkOperation>()
                    };
                }
            }

            if (bulkRequest.Operations.Count > 0)
            {
                bulkResponses.Add(elastic.BulkAsync(bulkRequest));
            }

            Task.WaitAll(bulkResponses.ToArray());

            watch.Stop();
            Console.WriteLine("Total Time: " + watch.Elapsed);

        }
    }
}
