﻿Imports CommandLine

Module Program

    Sub Main(args As String())
            Console.WriteLine("Hellow CommandLine in vb.net")
            Parser.Default.ParseArguments(Of Options)(args) _
            .WithParsed(Sub(opts) Run(opts)) _
            .WithNotParsed(Sub(errs) HandleParseError(errs))
        End Sub


        Private Sub HandleParseError(errs As IEnumerable(Of [Error]))
            If errs.IsVersion() Then
                Console.WriteLine("Version Request")
                Return
            End If

            If errs.IsHelp() Then
                Console.WriteLine("Help Request")
                Return
            End If

            Console.WriteLine("Parser Fail")
        End Sub

        Private Sub Run(opts As Options)
            Console.WriteLine("Parser success")
        End Sub

End Module
