import { Injectable, Inject, Optional, InjectionToken, NgZone, PLATFORM_ID } from '@angular/core';
import { createStorageRef } from './ref';
import { FirebaseAppConfig, FirebaseAppName, FirebaseZoneScheduler, _firebaseAppFactory } from 'angularfire2';
export var StorageBucket = new InjectionToken('angularfire2.storageBucket');
var AngularFireStorage = (function () {
    function AngularFireStorage(config, name, storageBucket, platformId, zone) {
        this.scheduler = new FirebaseZoneScheduler(zone, platformId);
        this.storage = zone.runOutsideAngular(function () {
            var app = _firebaseAppFactory(config, name);
            return app.storage(storageBucket || undefined);
        });
    }
    AngularFireStorage.prototype.ref = function (path) {
        return createStorageRef(this.storage.ref(path), this.scheduler);
    };
    AngularFireStorage.prototype.upload = function (path, data, metadata) {
        var storageRef = this.storage.ref(path);
        var ref = createStorageRef(storageRef, this.scheduler);
        return ref.put(data, metadata);
    };
    AngularFireStorage.decorators = [
        { type: Injectable },
    ];
    AngularFireStorage.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: [FirebaseAppConfig,] },] },
        { type: undefined, decorators: [{ type: Optional }, { type: Inject, args: [FirebaseAppName,] },] },
        { type: undefined, decorators: [{ type: Optional }, { type: Inject, args: [StorageBucket,] },] },
        { type: Object, decorators: [{ type: Inject, args: [PLATFORM_ID,] },] },
        { type: NgZone, },
    ]; };
    return AngularFireStorage;
}());
export { AngularFireStorage };
//# sourceMappingURL=storage.js.map