/*
 * Decompiled with CFR 0.152.
 */
package com.github.aborn.codepulse.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class ConfigFile {
    private static final String fileName = ".codepulse.cfg";
    private static String cachedConfigFile = null;

    private static String getConfigFilePath() {
        if (cachedConfigFile == null) {
            File folder;
            if (System.getenv("CODEPULSE_HOME") != null && !System.getenv("CODEPULSE_HOME").trim().isEmpty() && (folder = new File(System.getenv("CODEPULSE_HOME"))).exists()) {
                cachedConfigFile = new File(folder, fileName).getAbsolutePath();
                System.out.printf("Using $CODEPULSE_HOME for config folder: %s%n", cachedConfigFile);
                return cachedConfigFile;
            }
            cachedConfigFile = new File(System.getProperty("user.home"), fileName).getAbsolutePath();
            System.out.println("Using $HOME for config folder: " + cachedConfigFile);
        }
        return cachedConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String get(String section, String key) {
        String file = ConfigFile.getConfigFilePath();
        String val = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] parts;
                    if (line.trim().contains("=") && (parts = line.split("=")).length == 2 && parts[0].trim().equals(key)) {
                        val = parts[1].trim();
                        br.close();
                        String string = val;
                        return string;
                    }
                    line = br.readLine();
                }
                return val;
            }
            catch (Exception e) {
                e.printStackTrace();
                return val;
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(String section, String key, String val) {
        String file = ConfigFile.getConfigFilePath();
        StringBuilder contents = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            try {
                String currentSection = "";
                String line = br.readLine();
                Boolean found = false;
                while (line != null) {
                    if (line.trim().startsWith("[") && line.trim().endsWith("]")) {
                        if (section.toLowerCase().equals(currentSection) && !found.booleanValue()) {
                            contents.append(key + " = " + val + "\n");
                            found = true;
                        }
                        currentSection = line.trim().substring(1, line.trim().length() - 1).toLowerCase();
                        contents.append(line + "\n");
                    } else if (section.toLowerCase().equals(currentSection)) {
                        String[] parts = line.split("=");
                        String currentKey = parts[0].trim();
                        if (currentKey.equals(key)) {
                            if (!found.booleanValue()) {
                                contents.append(key + " = " + val + "\n");
                                found = true;
                            }
                        } else {
                            contents.append(line + "\n");
                        }
                    } else {
                        contents.append(line + "\n");
                    }
                    line = br.readLine();
                }
                if (!found.booleanValue()) {
                    if (!section.toLowerCase().equals(currentSection)) {
                        contents.append("[" + section.toLowerCase() + "]\n");
                    }
                    contents.append(key + " = " + val + "\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e1) {
            contents = new StringBuilder();
            contents.append("[" + section.toLowerCase() + "]\n");
            contents.append(key + " = " + val + "\n");
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file, "UTF-8");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (writer != null) {
            writer.print(contents.toString());
            writer.close();
        }
    }
}

