/*
 * Decompiled with CFR 0.152.
 */
package com.github.aborn.codepulse.ui;

import com.github.aborn.codepulse.tc.TimeTraceLogger;
import com.github.aborn.codepulse.tc.transfer.DataSenderHelper;
import com.github.aborn.codepulse.tc.transfer.SenderResponse;
import com.github.aborn.codepulse.tc.transfer.ServerInfo;
import com.github.aborn.codepulse.ui.datatypes.PlaceholderTextField;
import com.github.aborn.codepulse.utils.ConfigFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class Settings
extends DialogWrapper {
    private final JPanel panel;
    private final JLabel idLabel;
    private final PlaceholderTextField idText;
    private final JLabel tokenLabel;
    private final PlaceholderTextField tokenText;
    private Project project;

    public Settings(@Nullable Project project) {
        super(project, true);
        this.project = project;
        this.setTitle("CodePulse User Settings");
        this.setOKButtonText("Save");
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(0, 2));
        this.idLabel = new JLabel("User ID:", 0);
        this.panel.add(this.idLabel);
        this.idText = new PlaceholderTextField(30);
        this.idText.setPlaceholder(" Please input your github id.");
        String id = ConfigFile.get("settings", "id");
        this.idText.setText(id);
        this.panel.add(this.idText);
        this.tokenLabel = new JLabel("User Token:", 0);
        this.panel.add(this.tokenLabel);
        this.tokenText = new PlaceholderTextField();
        this.tokenText.setPlaceholder(" Please input your token.");
        this.panel.add(this.tokenText);
        String token = ConfigFile.get("settings", "token");
        this.tokenText.setText(token);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.panel;
    }

    protected ValidationInfo doValidate() {
        String id = this.idText.getText();
        String token = this.tokenText.getText();
        if ("webx".equals(id) && "8ba394513f8420e".equals(token)) {
            return null;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{token}) && token.length() == 10 && token.startsWith("0x")) {
            return null;
        }
        return new ValidationInfo("Invalid user id or token.");
    }

    public void doOKAction() {
        String token;
        String id = this.idText.getText();
        SenderResponse senderResponse = DataSenderHelper.validate(id, token = this.tokenText.getText());
        if (senderResponse.getCode() != 200 || !senderResponse.getStatus().booleanValue()) {
            TimeTraceLogger.info("settings is error, token: " + token + ", id: " + id);
            Messages.showMessageDialog((Project)this.project, (String)("Invalid user id or token\uff01ErrorCode:" + senderResponse.getCode() + "," + senderResponse.getMessage()), (String)"Error", (Icon)Messages.getInformationIcon());
            return;
        }
        TimeTraceLogger.info("settings is success, token: " + token + ", id: " + id);
        ConfigFile.set("settings", "id", id);
        ConfigFile.set("settings", "token", token);
        ServerInfo.setToken(token);
        super.doOKAction();
    }
}

