/*
 * Decompiled with CFR 0.152.
 */
package com.github.aborn.codepulse.tc.transfer;

import com.github.aborn.codepulse.tc.DayBitSet;
import com.github.aborn.codepulse.tc.TimeTraceLogger;
import com.github.aborn.codepulse.tc.transfer.BaseResponse;
import com.github.aborn.codepulse.tc.transfer.SenderEntity;
import com.github.aborn.codepulse.tc.transfer.SenderResponse;
import com.github.aborn.codepulse.tc.transfer.ServerInfo;
import com.github.aborn.codepulse.tc.transfer.UserActionEntity;
import com.github.aborn.codepulse.tc.transfer.UserEntity;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class DataSenderHelper {
    private static final BitSet lastPostData = new BitSet(2880);
    private static Date lastPostDate = null;

    public static void main(String[] args) {
        DataSenderHelper.testPost();
    }

    public static void testPost() {
        DayBitSet dayBitSet = new DayBitSet();
        dayBitSet.setSlotByCurrentTime();
        dayBitSet.set(1);
        SenderResponse response = DataSenderHelper.validate("webx", "8ba394513f8420e");
        System.out.println(response);
    }

    public static String postData(DayBitSet dayBitSet) {
        if (!DataSenderHelper.dataSenderSwitch()) {
            return "error, data sender switch off.";
        }
        if (dayBitSet.countOfCodingSlot() == 0) {
            return "No need to post, reason: data empty.";
        }
        if (!dayBitSet.isToday()) {
            return "No need to post, reason: is not today's data. " + dayBitSet.getDay();
        }
        ServerInfo serverInfo = ServerInfo.getConfigServerInfo();
        if (serverInfo == null) {
            return "User config not provided, no posting data.";
        }
        UserActionEntity userActionEntity = new UserActionEntity();
        userActionEntity.setToken(serverInfo.getToken());
        userActionEntity.setDayBitSetArray(dayBitSet.getDayBitSetByteArray());
        userActionEntity.setDay(dayBitSet.getDay());
        Date currentDate = new Date();
        if (lastPostDate != null && lastPostData.cardinality() == dayBitSet.countOfCodingSlot() && (currentDate.getTime() - lastPostDate.getTime()) / 1000L < 300L) {
            return "No need to post, reason: time to short.";
        }
        SenderResponse result = DataSenderHelper.postDataJson(serverInfo.getUrl(), userActionEntity);
        TimeTraceLogger.info("after postdata, status:" + result.getStatus());
        lastPostDate = currentDate;
        lastPostData.clear();
        lastPostData.or(dayBitSet.getCodingBitSet());
        return result.getMessage();
    }

    public static SenderResponse validate(String id, String token) {
        UserEntity userEntity = new UserEntity(token, id);
        return DataSenderHelper.postDataJson("https://aborn.me/webx/user/postUserConfig", userEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SenderResponse postDataJson(String url, SenderEntity senderEntity) {
        SenderResponse senderResponse = new SenderResponse("", true);
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(DataSenderHelper.completed(url));
        Object result = null;
        try {
            StringEntity httpEntity = new StringEntity(senderEntity.toJson());
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)httpEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            BaseResponse baseResponse = DataSenderHelper.toString(response.getEntity());
            if (baseResponse == null) {
                result = "Error in http request.";
            } else {
                senderResponse.setStatus(baseResponse.isStatus());
                senderResponse.setMessage(baseResponse.getMsg());
                senderResponse.setCode(baseResponse.getCode());
            }
            DataSenderHelper.release(response, httpClient);
        }
        catch (IOException e) {
            result = "There was an error accessing to URL: " + url + "\n\n" + e.toString();
            senderResponse.setStatus(false);
        }
        finally {
            DataSenderHelper.release(response, httpClient);
        }
        senderResponse.setMessage((String)result);
        return senderResponse;
    }

    private static String completed(String url) {
        if (!((String)url).startsWith("http://") && !((String)url).startsWith("https://")) {
            url = "http://" + (String)url;
        }
        return url;
    }

    private static void release(CloseableHttpResponse response, CloseableHttpClient httpClient) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static BaseResponse toString(HttpEntity entity) {
        String result = null;
        try {
            result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(result, JsonObject.class);
        TimeTraceLogger.info("http post res:" + result);
        int code = jsonObject.get("code").getAsInt();
        boolean status = jsonObject.get("status").getAsBoolean();
        String msg = jsonObject.get("msg").getAsString();
        BaseResponse baseResponse = new BaseResponse(status, msg, code);
        return baseResponse;
    }

    private static boolean dataSenderSwitch() {
        return true;
    }
}

