/*
 * Decompiled with CFR 0.152.
 */
package com.github.aborn.codepulse.tc;

import com.github.aborn.codepulse.tc.ActionPoint;
import com.github.aborn.codepulse.tc.DayBitSet;
import com.github.aborn.codepulse.tc.TimeTraceLogger;
import com.github.aborn.codepulse.tc.TraceRecorder;
import com.github.aborn.codepulse.tc.transfer.DataSenderHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class TimeTrace
implements Disposable {
    public static Boolean DEBUG = false;
    private static final DayBitSet CURRENT_DAY_BIT_SET = new DayBitSet();
    private static Boolean READY = false;
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);
    private static ScheduledFuture<?> scheduledFixture;
    public static final BigDecimal FREQUENCY;
    public static BigDecimal lastTime;
    private static final int QUEUE_TIMEOUT_SECONDS = 30;
    private static final ConcurrentLinkedQueue<ActionPoint> ACTION_POINTS;

    public TimeTrace() {
        this.init();
    }

    public void init() {
        if (!READY.booleanValue()) {
            READY = true;
            TimeTrace.setLoggingLevel();
            this.setupQueueProcessor();
            TimeTraceLogger.info("TimeTrace init finished.");
        }
    }

    public static void record() {
        TimeTrace timeTrace = (TimeTrace)ServiceManager.getService(TimeTrace.class);
        timeTrace.init();
        CURRENT_DAY_BIT_SET.clearIfNotToday();
        int currentSlot = CURRENT_DAY_BIT_SET.setSlotByCurrentTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int hours = calendar.get(11);
        int index = hours * 60 * 2;
        TimeTraceLogger.info("recorded, slot:" + currentSlot + ", hour_slot:" + (currentSlot - index));
        TimeTraceLogger.info(CURRENT_DAY_BIT_SET.getCurrentHourSlotInfo());
        if (TraceRecorder.isOpended()) {
            int openedTimeSlot = TraceRecorder.getOpenedSlot();
            TimeTraceLogger.info("current_slot=" + currentSlot + ", open_slot=" + openedTimeSlot);
            if (openedTimeSlot >= 0) {
                int findVerIndex = -1;
                for (int i = currentSlot - 1; i >= openedTimeSlot; --i) {
                    if (!CURRENT_DAY_BIT_SET.get(i)) continue;
                    findVerIndex = i;
                    break;
                }
                if (findVerIndex >= 0 && findVerIndex < currentSlot && currentSlot - findVerIndex < 10) {
                    for (int j = findVerIndex + 1; j < currentSlot; ++j) {
                        CURRENT_DAY_BIT_SET.set(j);
                    }
                    TimeTraceLogger.info("TRACED 5 Minutes:" + CURRENT_DAY_BIT_SET.getCurrentHourSlotInfo());
                }
            }
        }
    }

    public static void appendActionPoint(@NotNull VirtualFile file, Project project, boolean isWrite) {
        if (file == null) {
            TimeTrace.$$$reportNull$$$0(0);
        }
        TimeTrace service = (TimeTrace)ServiceManager.getService(TimeTrace.class);
        service.init();
        BigDecimal currentTimestamp = TimeTrace.getCurrentTimestamp();
        if (!isWrite && !TimeTrace.enoughTimePassed(currentTimestamp)) {
            return;
        }
        String language = TimeTrace.getLanguage(file);
        ActionPoint actionPoint = new ActionPoint();
        String projectName = project != null ? project.getName() : null;
        actionPoint.setEntity(file.getPath());
        actionPoint.setLanguage(language);
        actionPoint.setTimestamp(currentTimestamp);
        actionPoint.setWrite(isWrite);
        actionPoint.setProject(projectName);
        lastTime = currentTimestamp;
        TimeTraceLogger.info("appendActionPoint.");
        ApplicationManager.getApplication().executeOnPooledThread(() -> ACTION_POINTS.add(actionPoint));
    }

    public static boolean enoughTimePassed(BigDecimal currentTime) {
        return lastTime.add(FREQUENCY).compareTo(currentTime) < 0;
    }

    private void setupQueueProcessor() {
        Runnable handler = TimeTrace::processActionsQueue;
        long delay = 30L;
        scheduledFixture = SCHEDULER.scheduleAtFixedRate(handler, delay, delay, TimeUnit.SECONDS);
    }

    private static void processActionsQueue() {
        try {
            if (READY.booleanValue()) {
                String message = DataSenderHelper.postData(CURRENT_DAY_BIT_SET);
                TimeTraceLogger.info("POST DATA:" + message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TimeTraceLogger.info("SCHEDULER running exception.");
        }
    }

    private static void sendTraceActions(ArrayList<ActionPoint> extraHeartbeats) {
        TimeTraceLogger.info("send message. size = " + extraHeartbeats.size());
    }

    public static BigDecimal getCurrentTimestamp() {
        return new BigDecimal(String.valueOf((double)System.currentTimeMillis() / 1000.0)).setScale(4, 4);
    }

    private static String getLanguage(VirtualFile file) {
        FileType type = file.getFileType();
        return type.getName();
    }

    public static void setLoggingLevel() {
        if (DEBUG.booleanValue()) {
            TimeTraceLogger.setLevel(LogLevel.DEBUG);
        } else {
            TimeTraceLogger.setLevel(LogLevel.INFO);
        }
    }

    public void dispose() {
        try {
            scheduledFixture.cancel(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TimeTrace.processActionsQueue();
    }

    static {
        FREQUENCY = new BigDecimal(120);
        lastTime = new BigDecimal(0);
        ACTION_POINTS = new ConcurrentLinkedQueue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/github/aborn/codepulse/tc/TimeTrace", "appendActionPoint"));
    }
}

