/*
 * Decompiled with CFR 0.152.
 */
package com.github.aborn.codepulse.tc;

import com.github.aborn.codepulse.utils.DateBitSlotUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;

public class DayBitSet
implements Serializable {
    BitSet codingBitSet = new BitSet(2880);
    String day;

    public DayBitSet() {
        this(new Date());
    }

    public DayBitSet(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.day = simpleDateFormat.format(date);
    }

    public void set(int slot) {
        this.codingBitSet.set(slot);
    }

    public boolean get(int slot) {
        return this.codingBitSet.get(slot);
    }

    public int setSlotByCurrentTime() {
        return this.setSlotByTime(new Date());
    }

    public int setSlotByTime(Date date) {
        int slotIndex = DateBitSlotUtils.getSlotIndex(date);
        this.set(slotIndex);
        return slotIndex;
    }

    public byte[] getDayBitSetByteArray() {
        return this.codingBitSet.toByteArray();
    }

    public int countOfCodingSlot() {
        return this.codingBitSet.cardinality();
    }

    public int codingTimeSeconds() {
        return this.countOfCodingSlot() * 30;
    }

    public double codingTimeMinutes() {
        return (double)this.codingTimeSeconds() / 60.0;
    }

    public String toString() {
        return "Day:" + this.day + ", Coding Time:" + this.codingTimeSeconds() + "s(" + this.codingTimeMinutes() + "m).";
    }

    public static void main(String[] args) {
        DayBitSet dayBitSet = new DayBitSet();
        dayBitSet.set(1);
        System.out.println(dayBitSet.toString());
    }

    public String getDay() {
        return this.day;
    }

    public boolean isToday() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(new Date()).equals(this.day);
    }

    public void clearIfNotToday() {
        if (this.isToday()) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.day = simpleDateFormat.format(new Date());
        this.codingBitSet.clear();
    }

    public BitSet getCodingBitSet() {
        return this.codingBitSet;
    }

    public String getCurrentHourSlotInfo() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return this.getHourSlotInfo(calendar.get(11));
    }

    public String getHourSlotInfo(int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        Calendar calendarSet = Calendar.getInstance();
        calendarSet.set(calendar.get(1), calendar.get(2), calendar.get(5), hour, 0, 0);
        int index = calendarSet.get(11) * 60 * 2;
        StringBuilder result = new StringBuilder("" + hour);
        result.append("[").append(index).append("+]:");
        int slotHourIndex = 0;
        for (int i = index; i < index + 120; ++i) {
            if (this.get(i)) {
                result.append(slotHourIndex).append(", ");
            }
            ++slotHourIndex;
        }
        return result.toString();
    }
}

